dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 260, 220, "assets/images/table/island", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 2, 2, 410, 355, "assets/images/table/island_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 3, 180, 350, "assets/images/table/island", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 4, 4, 270, 485, "assets/images/table/island", "assets/images/food/item_mark4", "B" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table1;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female01;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 10, 13000);


-- Group 3

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 12, 30000);

-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = table3;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 14, 60000);

-- Group 5

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(15, 16, 120000);


-- Group 6

guest = LManager.GenGuest(male03);
guest.matchType = table3;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_TABLE + table1;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 20, 150000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("cakeTipDelay", 50000); 
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 130000 );

LManager:SetLevelSetting ("bridesmaidsDelay", 100000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);


LManager:AddReseatingRequestForGuest( 100000, female01 );
LManager:AddReseatingRequestForGuest( 140000, female04 );
LManager:AddReseatingRequestForGuest( 220000, female04 );



-- Set up the Level Settings
LManager:SetLevelNumber(4,7);
LManager:SetLevelScores(8000, 10500);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_2.ogg","assets/audio/music/Dance Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );